/*
 * Decompiled with CFR 0.152.
 */
package reliquary.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import reliquary.client.gui.GuiBase;
import reliquary.common.gui.AlkahestTomeMenu;
import reliquary.crafting.AlkahestryRecipeRegistry;
import reliquary.init.ModItems;
import reliquary.util.LanguageHelper;

public class AlkahestryTomeGui
extends GuiBase<AlkahestTomeMenu> {
    private static final ResourceLocation BOOK_TEX = new ResourceLocation("reliquary", "textures/gui/book.png");

    public AlkahestryTomeGui(AlkahestTomeMenu container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
    }

    protected void m_7027_(PoseStack matrixStack, int x, int y) {
        this.drawTitleText(matrixStack);
        this.drawTomeText(matrixStack, this.f_96547_);
    }

    protected void m_7286_(PoseStack poseStack, float partialTicks, int x, int y) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindTexture(BOOK_TEX);
        this.m_93228_(poseStack, (this.f_96543_ - 146) / 2, (this.f_96544_ - 179) / 2, 0, 0, 146, 179);
        this.m_93228_(poseStack, (this.f_96543_ - 16) / 2 + 19, (this.f_96544_ - 179) / 2 + 148, 0, 180, 10, 10);
        this.m_93228_(poseStack, (this.f_96543_ - 16) / 2 - 14, (this.f_96544_ - 179) / 2 + 148, 10, 180, 10, 10);
        this.drawItemStack(new ItemStack((ItemLike)ModItems.ALKAHESTRY_TOME.get()), (this.f_96543_ - 16) / 2, (this.f_96544_ - 179) / 2 + 145);
        AlkahestryRecipeRegistry.getDrainRecipe().ifPresent(drainRecipe -> {
            this.drawItemStack(drainRecipe.m_8043_(), (this.f_96543_ - 16) / 2 - 32, (this.f_96544_ - 179) / 2 + 145);
            this.drawItemStack(drainRecipe.m_8043_(), (this.f_96543_ - 16) / 2 + 32, (this.f_96544_ - 179) / 2 + 145);
        });
    }

    private void drawTomeText(PoseStack matrixStack, Font renderer) {
        String values = "gui.reliquary.alkahestry_tome.text";
        if (!LanguageHelper.getLocalization(values, new Object[0]).equals(values)) {
            values = LanguageHelper.getLocalization(values, new Object[0]);
        }
        int count = 1;
        for (String value : values.split(";")) {
            Objects.requireNonNull(renderer);
            int y = 36 + count * 9;
            renderer.m_92883_(matrixStack, value, 31.0f, (float)y, 0);
            ++count;
        }
    }

    private void drawTitleText(PoseStack matrixStack) {
        String values = "Perform basic,;intermediate or;advanced Alkahestry.";
        if (!LanguageHelper.getLocalization(values, new Object[0]).equals(values)) {
            values = LanguageHelper.getLocalization(values, new Object[0]);
        }
        int count = 1;
        for (String value : values.split(";")) {
            int x = (146 - this.f_96547_.m_92895_(value)) / 2;
            Objects.requireNonNull(this.f_96547_);
            int y = 4 + count * 9;
            this.f_96547_.m_92883_(matrixStack, value, (float)x + 15.0f, (float)y, 0);
            ++count;
        }
    }
}

